%
%   Book: MATLAB-Based Electromagnetics (Pearson Prentice Hall)
%   Author: Branislav M. Notaros
%   Instructor Resources
%   (c) 2011
%
%   This MATLAB code or any part of it may be used only for 
%   educational purposes associated with the book
%
%
%

% This program calculates breakdown voltage in coaxial cable with arbitrary
% number of coaxial dielectric layers.

clear all;
close all;
EPS0 = 8.8542*10^(-12); 

% Number of dielectric layers
N = input('Enter the number of coaxial dielectric layers: ');

% Dielectric permittivity constant, smaller radius of dielectric layer and 
% dielectric strength for each dielectric layer.
for i = 1:N
    EPSR(i) = input(['Enter dielectric rel. permittivity in ',int2str(i),'. layer: ']);
    a(i) = input(['Enter inner radius (in mm) of ',int2str(i),'. layer: ']);
    a(i) = a(i)/1000;
    Ecr(i) = input(['Enter dielectric strength (in MV/m) for ',int2str(i),'. layer: ']);
    Ecr(i) = Ecr(i)*10^6;
end;
b = input(['Enter outer radius (in mm) of ',int2str(N),'. layer: ']);
b = b/1000;
% Maximum of line charge before breakdown - calculation for each layer
Qprim = 2*pi*EPS0.*EPSR.*a.*Ecr;
% In which layer will happen breakdown - minimum of the line charge
[Qprimmin,index] = min(Qprim);
fprintf(['Breakdown will happen in ',int2str(index),'. dielectric layer for Q` = ']);
fprintf('%f nC/m.\n',Qprimmin*10^9);

% Breakdown voltage
Vcr = 0;   % Initialization
if N>1
    for i=1:N-1  % Integral E*dl in the first N-1 layers
        Vcr = Vcr + Qprimmin/2/pi/EPS0/EPSR(i)*log(a(i+1)/a(i));
    end
end   
% Addition of integral in the last layer
Vcr = Vcr + Qprimmin/2/pi/EPS0/EPSR(N)*log(b/a(N));
fprintf('Breakdown voltage is: %f V.\n',Vcr);